<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\KAI\AlertLog;
use Illuminate\Http\Request;

class AlertLogController extends Controller
{
    // GET /api/stasiun/alerts
    public function index(Request $request)
    {
        $query = AlertLog::query();
        
        // Filter ?is_read=0
        if ($request->has('is_read')) {
            $query->where('is_read', (bool)$request->input('is_read'));
        }
        
        return $query->with('acUnit:id,carriage_number,unit_number')
                     ->orderBy('created_at', 'desc')
                     ->paginate(50);
    }

    // POST /api/stasiun/alerts/{id}/mark-read
    public function markAsRead($id)
    {
        $log = AlertLog::findOrFail($id);
        $log->update(['is_read' => true]);
        return response()->json($log);
    }
    
    // (Fungsi store, show, update, destroy bawaan --api)
    // (Bisa dihapus jika tidak perlu)
}