<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User; // (Pastikan path User model Anda benar)
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\ValidationException;

class AuthController extends Controller
{
    /**
     * POST /api/stasiun/login
     * (Untuk login & mendapatkan Bearer Token)
     */
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        $user = User::where('email', $request->email)->first();

        if (! $user || ! Hash::check($request->password, $user->password)) {
            throw ValidationException::withMessages([
                'email' => ['Login gagal.'],
            ]);
        }
        
        // Hapus token lama, buat yang baru
        $user->tokens()->delete();
        $token = $user->createToken('postman-token')->plainTextToken;

        return response()->json([
            'message' => 'Login sukses',
            'user' => $user->full_name,
            'token' => $token // <-- Ini adalah Bearer Token Anda
        ]);
    }

    /**
     * POST /api/stasiun/logout (Butuh Auth)
     */
    public function logout(Request $request)
    {
        // Hapus token yang sedang dipakai
        $request->user()->currentAccessToken()->delete();
        return response()->json(['message' => 'Logout sukses']);
    }
}