<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\KAI\Station;
use Illuminate\Http\Request;

class StationController extends Controller
{
    // GET /api/stasiun/stations
    public function index()
    {
        return Station::all();
    }

    // POST /api/stasiun/stations
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:100',
            'code' => 'nullable|string|max:20|unique:stations',
            'location' => 'nullable|string',
        ]);
        $station = Station::create($validated);
        return response()->json($station, 201);
    }

    // GET /api/stasiun/stations/{id}
    public function show(Station $station) // Otomatis 404 jika tidak ketemu
    {
        return $station;
    }

    // PUT /api/stasiun/stations/{id}
    public function update(Request $request, Station $station)
    {
        $validated = $request->validate([
            'name' => 'string|max:100',
            'code' => 'nullable|string|max:20|unique:stations,code,' . $station->id,
            'location' => 'nullable|string',
        ]);
        $station->update($validated);
        return response()->json($station);
    }

    // DELETE /api/stasiun/stations/{id}
    public function destroy(Station $station)
    {
        $station->delete();
        return response()->json(null, 204); // 204 = No Content
    }
}