<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\KAI\Threshold;
use Illuminate\Http\Request;

class ThresholdController extends Controller
{
    // GET /api/stasiun/thresholds
    public function index()
    {
        return Threshold::all();
    }

    // POST /api/stasiun/thresholds
    public function store(Request $request)
    {
        $validated = $request->validate([
            'sensor_type' => 'required|string|max:50|unique:thresholds',
            'lower_limit' => 'required|numeric',
            'upper_limit' => 'required|numeric|gte:lower_limit',
            'unit' => 'required|string|max:20',
            'is_active' => 'nullable|boolean',
        ]);
        $threshold = Threshold::create($validated);
        return response()->json($threshold, 201);
    }

    // GET /api/stasiun/thresholds/{id}
    public function show(Threshold $threshold)
    {
        return $threshold;
    }

    // PUT /api/stasiun/thresholds/{id}
    public function update(Request $request, Threshold $threshold)
    {
        $validated = $request->validate([
            'sensor_type' => 'string|max:50|unique:thresholds,sensor_type,' . $threshold->id,
            'lower_limit' => 'numeric',
            'upper_limit' => 'numeric|gte:lower_limit',
            'unit' => 'string|max:20',
            'is_active' => 'boolean',
        ]);
        $threshold->update($validated);
        return response()->json($threshold);
    }

    // DELETE /api/stasiun/thresholds/{id}
    public function destroy(Threshold $threshold)
    {
        $threshold->delete();
        return response()->json(null, 204);
    }
}