<?php

namespace App\Models\KAI;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AcUnit extends Model
{
    use HasFactory;
    protected $fillable = [
        'station_id',
        'carriage_number',
        'unit_number',
        'location',
        'is_on',
        'mode',
        'setpoint',
        'status',
    ];
    
    // 1 Unit AC milik 1 Stasiun
    public function station()
    {
        return $this->belongsTo(Station::class);
    }
    
    // 1 Unit AC punya banyak data sensor
    public function sensorReadings()
    {
        return $this->hasMany(SensorReading::class);
    }
    
    // 1 Unit AC punya banyak log alert
    public function alertLogs()
    {
        return $this->hasMany(AlertLog::class);
    }
}