<?php

namespace App\Models\KAI;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SensorReading extends Model
{
    use HasFactory;
    
    // Data time-series biasanya tidak butuh 'updated_at'
    public $timestamps = false; 
    
    protected $fillable = [
        'ac_unit_id',
        'recorded_at',
        'power',
        'current',
        'voltage',
        'temperature',
        'latitude',
        'longitude',
        'status',
    ];
    
    // 1 data sensor milik 1 Unit AC
    public function acUnit()
    {
        return $this->belongsTo(AcUnit::class);
    }
}