<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateThresholdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('thresholds', function (Blueprint $table) {
            $table->id();
            $table->string('sensor_type', 50)->unique(); // 'power', 'current', 'voltage', 'temperature'
            $table->decimal('lower_limit', 10, 2)->default(0);
            $table->decimal('upper_limit', 10, 2)->default(100);
            $table->string('unit', 20); // 'kW', 'A', 'V', '°C'
            $table->boolean('is_active')->default(true); // Lebih jelas dari 'status'
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('thresholds');
    }
}
