<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAcUnitsTable extends Migration
{
    public function up()
    {
        Schema::create('ac_units', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('station_id')->nullable()->constrained('stations')->onDelete('set null');
            
            $table->string('carriage_number', 50);
            $table->string('unit_number', 50); 
            $table->string('location', 100)->nullable();
            
            $table->boolean('is_on')->default(false);
            $table->string('mode', 20)->default('auto'); 
            $table->decimal('setpoint', 4, 1)->default(22.0); 
            
            $table->string('status', 20)->default('normal'); 
            $table->timestamps(); 
        });
    }

    public function down()
    {
        Schema::dropIfExists('ac_units');
    }
}