<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSensorReadingsTable extends Migration
{
    public function up()
    {
        Schema::create('sensor_readings', function (Blueprint $table) {
            $table->id();
            
            $table->foreignId('ac_unit_id')->constrained('ac_units')->onDelete('cascade');
            
            $table->timestamp('recorded_at')->useCurrent()->index();
            
            $table->decimal('power', 8, 2)->nullable(); // Daya (kW)
            $table->decimal('current', 8, 2)->nullable(); // Arus (A)
            $table->decimal('voltage', 8, 2)->nullable(); // Tegangan (V)
            $table->decimal('temperature', 4, 1)->nullable(); // Suhu aktual (°C)

            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            
            $table->string('status', 20)->default('normal');

            $table->timestamp('created_at')->useCurrent();
        });
    }

    public function down()
    {
        Schema::dropIfExists('sensor_readings');
    }
}