<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAlertLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('alert_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ac_unit_id')->nullable()->constrained('ac_units')->onDelete('set null');
            $table->string('alert_type', 50); // 'threshold_exceeded', 'unit_offline'
            $table->string('severity', 20)->default('info'); // 'info', 'warning', 'critical'
            $table->text('message'); // Pesan error/notifikasi
            $table->boolean('is_read')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('alert_logs');
    }
}
