<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class RemoveLatitudeLongitudeFromSensorReadingsTable extends Migration
{
    /**
     * Run the migrations.
     * (Akan menghapus kolom)
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sensor_readings', function (Blueprint $table) {
            // Perintah untuk menghapus kolom
            $table->dropColumn(['latitude', 'longitude']);
        });
    }

    /**
     * Reverse the migrations.
     * (Akan mengembalikan kolom jika Anda rollback)
     *
     * @return void
     */
    public function down()
    {
        Schema::table('sensor_readings', function (Blueprint $table) {
            // Ini adalah kebalikan dari 'up', untuk jaga-jaga
            $table->decimal('latitude', 10, 8)->nullable()->after('temperature');
            $table->decimal('longitude', 11, 8)->nullable()->after('latitude');
        });
    }
}