<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\SensorReadingController;
use App\Http\Controllers\StationController;
use App\Http\Controllers\AcUnitController;
use App\Http\Controllers\ThresholdController;
use App\Http\Controllers\AlertLogController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

Route::prefix('stasiun')->name('kai.')->group(function () {

    // 1. Rute PUBLIK (Tidak butuh token)
    // Sekarang memanggil AuthController langsung
    Route::post('/login', [AuthController::class, 'login']);
    
    // 2. Rute PROTECTED (WAJIB pakai Bearer Token)
    Route::middleware('auth:sanctum')->group(function () {
            
        // Auth
        Route::post('/logout', [AuthController::class, 'logout']);

        // Sensor Data (GET Data)
        Route::post('/ingest', [SensorReadingController::class, 'store']);
        Route::get('/latest-readings', [SensorReadingController::class, 'getLatestReadings']);
        Route::get('/sensor-history/{ac_unit_id}', [SensorReadingController::class, 'getSensorHistory']);
        Route::get('/sensor-table', [SensorReadingController::class, 'getSensorTable']);

        // Kontrol AC (POST Data)
        Route::post('/ac-units/{id}/control', [AcUnitController::class, 'controlUnit']);
        Route::post('/ac-units/group-control', [AcUnitController::class, 'groupControl']);

        // Master Data CRUD (Resource)
        Route::apiResource('/stations', StationController::class);
        Route::apiResource('/thresholds', ThresholdController::class);

        // Master Data AC Units (Custom)
        Route::get('/ac-units', [AcUnitController::class, 'index']);
        Route::post('/ac-units', [AcUnitController::class, 'store']);
        Route::get('/ac-units/{id}', [AcUnitController::class, 'show']);
        Route::put('/ac-units/{id}', [AcUnitController::class, 'update']);
        Route::delete('/ac-units/{id}', [AcUnitController::class, 'destroy']);
        
        // Alert Logs (Custom)
        Route::get('/alerts', [AlertLogController::class, 'index']);
        Route::post('/alerts/{id}/mark-read', [AlertLogController::class, 'markAsRead']);
    });
});